﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Data;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using Microsoft.Reporting.WebForms;
using VeteransAffairs.Registries.Business.Utilities;
using VeteransAffairs.Registries.BusinessManager;
using Telerik.Web.UI;

public partial class TBISurveyPatientsCountsbyAlterationofConsciousness : System.Web.UI.Page
{

    #region PaGe Declarations

    private UserAccountManager _currentUser;
    List<ReportParameter> _reportParameters = new List<ReportParameter>();
    private int _allNodeCount = 0;
    #endregion

    protected void Page_Load(object sender, EventArgs e)
    {
        if (AccessAllowed())
        {
            ButtonRunReport.Enabled = true;
            ReportViewer1.Visible = true;
            if (!IsPostBack)
            {
                FillDivisionTree();
                FillFiscalYears();
                ButtonRunReport.Visible = true;
            }
        }
        else
        {
            Response.Redirect("ErrorPage.aspx?id=100");
        }
    }

    #region Page Control Events/Functions

    protected void FillFiscalYears()
    {
        Reports r = new Reports(_currentUser.UserId.ToString());
        DataSet ds = new DataSet();
        DataTable dtVISN = r.GetFiscalYears().Copy();

        DropDownListFiscalYear.DataSource = dtVISN;
        DropDownListFiscalYear.DataTextField = "Fiscal_Year_Name";
        DropDownListFiscalYear.DataValueField = "Fiscal_Year_Name";
        DropDownListFiscalYear.DataBind();
        DropDownListFiscalYear.Items.Insert(0, new RadListBoxItem("All", "All"));
    }

    protected void FillDivisionTree()
    {
        try
        {
            Reports r = new Reports(_currentUser.UserId.ToString());

            DataSet ds = new DataSet();

            DataTable dtVISN = r.GetVISNs().Copy();
            dtVISN.TableName = "VISNs";
            _allNodeCount = dtVISN.Rows.Count;

            DataTable dtFac = r.GetFacs().Copy();
            dtFac.TableName = "Facilities";
            _allNodeCount += dtFac.Rows.Count;
            r.AllDivisionNodeCount = _allNodeCount;

            ds.Tables.Add(dtVISN);
            ds.Tables.Add(dtFac);
            ds.Relations.Add("VISN_Facilities", ds.Tables[0].Columns["visnId"], ds.Tables[1].Columns["visn_fk"]);

            RadTreeNode all = new RadTreeNode("All", "ALL");
            rtvDivision.Nodes.Add(all);
            all.Expanded = true;

            foreach (DataRow visnRow in ds.Tables[0].Rows)
            {
                RadTreeNode visnNode = new RadTreeNode(visnRow["visnText"].ToString());
                visnNode.Value = visnRow["visnId"].ToString();

                all.Nodes.Add(visnNode);

                foreach (DataRow facRow in visnRow.GetChildRows("VISN_Facilities"))
                {
                    RadTreeNode facNode = new RadTreeNode(facRow["facText"].ToString());
                    facNode.Value = facRow["stationnumber"].ToString();
                    visnNode.Nodes.Add(facNode);
                }
            }
        }
        catch (Exception ex)
        {
        }
    }

    #endregion

    protected void Button1_Click(object sender, EventArgs e)
    {
        try
        {
            if (ButtonRunReport.CommandName == "Click")
            {
                Reports _report = new Reports(_currentUser.UserId.ToString());

                if (rtvDivision.SelectedNodes.Count > 0 || rtvDivision.CheckedNodes.Count > 0)
                {
                    #region Parse Data

                    string[] _visns, _fiscalquarters, _fiscalyears, _surveytypes, _facilitynames, _facilitystationnumbers;
                    string _cumulativereport = String.Empty;

                    _visns = _report.GetArrayListFromRadTreeView(rtvDivision, "VISNS", null);
                    _facilitynames = _report.GetArrayListFromRadTreeView(rtvDivision, "FACILITIES", null);
                    _facilitystationnumbers = _report.GetArrayListFromRadTreeView(rtvDivision, "STATIONNUMBERS", null);
                    _fiscalquarters = _report.GetStringArrayFromRadListForSurvey(DropDownListFiscalQuarter);
                    _fiscalyears = _report.GetStringArrayFromRadListForSurvey(DropDownListFiscalYear);
                    _surveytypes = _report.GetStringArrayFromRadListForSurvey(DropDownListSurveyType);


                    if (_facilitynames.Length > 0)
                    {
                        if (_visns.Length > 0 && _facilitynames[0] == null)
                        {
                            _facilitynames = _report.GetArrayListFromRadTreeView(rtvDivision, "UNCHECKED_FACS", _visns);
                        }
                    }

                    if (_facilitystationnumbers.Length > 0)
                    {
                        if (_visns.Length > 0 && _facilitystationnumbers[0] == null)
                        {
                            _facilitystationnumbers = _report.GetArrayListFromRadTreeView(rtvDivision, "UNCHECKED_STATIONS", _visns);
                        }
                    }

                    
                    if (chkCumulativeReport.Checked == true) { _cumulativereport = "1"; } else { _cumulativereport = "0"; }


                    #endregion

                    #region RunReport

                    ReportParameter _DimInstitutionVISN = new ReportParameter("DimInstitutionVISN", _visns);
                    ReportParameter _DimInstitutionStationNumber = new ReportParameter("DimInstitutionStationNumber", _facilitystationnumbers);
                    ReportParameter _DimInstitutionInstitutionDisplayName = new ReportParameter("DimInstitutionInstitutionDisplayName", _facilitynames);
                    ReportParameter _DimTimeFiscalYear = new ReportParameter("DimTimeFiscalYear", _fiscalyears);
                    ReportParameter _DimTimeFiscalQuarter = new ReportParameter("DimTimeFiscalQuarter", _fiscalquarters);
                    ReportParameter _DimQuestionSurveyType = new ReportParameter("DimQuestionSurveyType", _surveytypes);
                    ReportParameter _CumulativeReport = new ReportParameter("CumulativeReport", _cumulativereport);

                    ReportViewer1.Reset();

                    _reportParameters.Clear();
                    _reportParameters.Add(_DimInstitutionVISN);
                    _reportParameters.Add(_DimInstitutionStationNumber);
                    _reportParameters.Add(_DimInstitutionInstitutionDisplayName);
                    _reportParameters.Add(_DimTimeFiscalYear);
                    _reportParameters.Add(_DimTimeFiscalQuarter);
                    _reportParameters.Add(_DimQuestionSurveyType);
                    _reportParameters.Add(_CumulativeReport);

                    ReportViewer1.ServerReport.ReportPath = "TBISurveyPatientsCountsbyAlterationofConsciousness";
                    ReportViewer1.ServerReport.ReportServerUrl = new Uri(Helpers.GetConfigEntry("ReportingServer"));

                    if (ReportViewer1.ServerReport.ReportPath.IndexOf(Helpers.GetConfigEntry("BaseReportPath"), 0) == -1)
                    {
                        ReportViewer1.ServerReport.ReportPath = Helpers.GetConfigEntry("BaseReportPath") + ReportViewer1.ServerReport.ReportPath;
                    }

                    ReportViewer1.ServerReport.SetParameters(_reportParameters.ToArray());
                    ReportViewer1.ProcessingMode = ProcessingMode.Remote;
                    ReportViewer1.Visible = true;
                    ReportViewer1.Style.Add("margin-bottom", "26px");
                    ReportViewer1.ServerReport.Refresh();

                    #endregion
                }
            }
        }
        catch (Exception ex)
        {

        }
    }

    #region Private Functions
    private bool AccessAllowed()
    {
        _currentUser = (UserAccountManager)HttpContext.Current.User;
        return (_currentUser.IsInRole(16) || _currentUser.IsInRole(17) || _currentUser.IsInRole(18));
    }

    private void ReportViewer1_Toggle(object sender, System.ComponentModel.CancelEventArgs e)
    {
        Page.RegisterStartupScript("scrollup", "<script language=javascript>window.scrollTo(0,400);</script>");
    }

    #endregion

    #region Telerik Postback events

    protected void OnItemListFiscalQuarter_Check(object sender, RadListBoxItemEventArgs e)
    {
        ReportViewer1.Visible = false;
        if (e.Item != null)
        {
            if (e.Item.Value == "All" && e.Item.Checked == true)
            {
                foreach (RadListBoxItem rlb in DropDownListFiscalQuarter.Items)
                {
                    if (rlb.Value != "All")
                    {
                        rlb.Enabled = false;
                        rlb.Checked = true;
                    }
                }
            }
            else if (e.Item.Value == "All" && e.Item.Checked == false)
            {
                foreach (RadListBoxItem rlb in DropDownListFiscalQuarter.Items)
                {
                    rlb.Enabled = true;
                    rlb.Checked = false;
                }
            }
        }
    }

    protected void OnItemYearList_Check(object sender, RadListBoxItemEventArgs e)
    {
        ReportViewer1.Visible = false;
        if (e.Item != null)
        {
            if (e.Item.Value == "All" && e.Item.Checked == true)
            {
                foreach (RadListBoxItem rlb in DropDownListFiscalYear.Items)
                {
                    if (rlb.Value != "All")
                    {
                        rlb.Enabled = false;
                        rlb.Checked = true;
                    }
                }
            }
            else if (e.Item.Value == "All" && e.Item.Checked == false)
            {
                foreach (RadListBoxItem rlb in DropDownListFiscalYear.Items)
                {
                    rlb.Enabled = true;
                    rlb.Checked = false;
                }
            }
        }
    }

    protected void DropDownListSurveyType_Check(object sender, RadListBoxItemEventArgs e)
    {
        ReportViewer1.Visible = false;

    }


    private void SetALLValueOption(RadTreeNodeEventArgs _e)
    {
        try
        {
            if (_e.Node.Text == "All")
            {
                if (rtvDivision.CheckedNodes.Count == 0)
                {
                    foreach (RadTreeNode rtn in rtvDivision.GetAllNodes())
                    {
                        rtn.Enabled = true;
                    }
                }
                else
                {
                    if (rtvDivision.Nodes[0].Checked == true)
                    {
                        foreach (RadTreeNode rtn in rtvDivision.GetAllNodes())
                        {
                            if (rtn.Level != 0)
                            {
                                rtn.Enabled = false;
                                rtn.Checked = true;

                            }
                        }
                    }
                    else if (rtvDivision.Nodes[0].Checked == false)
                    {
                        foreach (RadTreeNode rtn in rtvDivision.GetAllNodes())
                        {
                            rtn.Enabled = true;
                            rtn.Checked = false;
                        }
                    }
                }
            }
        }
        catch (Exception ex)
        {
        }
    }

    protected void rtvDivision_NodeCheck(object sender, RadTreeNodeEventArgs e)
    {
        try
        {
            ReportViewer1.Visible = true;
            SetALLValueOption(e);
        }
        catch (Exception ex)
        {
        }
    }


    #endregion

}
